#include <set>
#include <iostream>
using namespace std;

const int maxn = 36 + 5;

typedef pair<double, double> pdd;

int n;
pdd As[maxn], Bs[maxn];

set<pdd> s;

pdd line_intersection(pdd A, pdd B, pdd C, pdd D)
{
    double a1 = B.second - A.second;
    double b1 = A.first - B.first;
    double c1 = a1 * A.first + b1 * A.second;
  
    double a2 = D.second - C.second;
    double b2 = C.first - D.first;
    double c2 = a2 * C.first + b2 * C.second;
  
    double d = a1 * b2 - a2 * b1;
  
    if (d == 0) 
        return pdd(-1.0, -1.0);
    else {
        double x = (b2 * c1 - b1 * c2) / d;
        double y = (a1 * c2 - a2 * c1) / d;
        return pdd(x, y);
    }
}

bool on_segment(pdd p, pdd A, pdd B) {
    if (p.first < min(A.first, B.first) || p.first > max(A.first, B.first))
        return 0;
    if (p.second < min(A.second, B.second) || p.second > max(A.second, B.second))
        return 0;
    return 1;
}

int main() {
    ios::sync_with_stdio(false);
    cin >> n;
    for (int i = 0; i < n; i++) {
        int a, b;
        cin >> a >> b;
        pdd A = pdd((a - 1) / 3, (a - 1) % 3);
        pdd B = pdd((b - 1) / 3, (b - 1) % 3);
        As[i] = A;
        Bs[i] = B;
    }
    for (int i = 0; i < n; i++)
        for (int j = i + 1; j < n; j++) {
            pdd inter = line_intersection(As[i], Bs[i], As[j], Bs[j]);
            if (inter.first == -1.0)
                continue;
            if (on_segment(inter, As[i], Bs[i]) && on_segment(inter, As[j], Bs[j]))
                s.insert(inter);
        }  
    for (int i = 1; i <= 9; i++)
        s.erase(pdd((i - 1) / 3, (i - 1) % 3));
    cout << (int)s.size() << endl;
    return 0;
}
